<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Post;
use App\Http\Requests\API\Therapists\TherapistPosts\CreateRequest;
use App\Http\Resources\API\PostsResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistPostsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_posts.index');
      // $this->middleware('permission:therapist_posts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_posts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_posts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_posts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_posts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_posts.update|therapist_posts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_posts =  $therapist->therapist_posts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_posts =  $therapist_posts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_posts =  $therapist_posts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_posts = $therapist_posts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_posts = $therapist_posts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_posts = $therapist_posts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_posts = $therapist_posts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_posts = $therapist_posts->get();
        return $therapist_posts;
      }
      $totalTherapistCertifications = $therapist_posts->count();
      $therapist_posts = $therapist_posts->paginate($req->perPage);
      $therapist_posts = PostsResource::collection($therapist_posts)->response()->getData(true);

      return $therapist_posts;
    }
    $therapist_posts = PostsResource::collection($therapist->therapist_posts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_posts;
  }

  /********* FETCH ALL TherapistPosts ***********/
    public function index()
    {
        $therapist_posts =  $this->getter();
        $response = generateResponse($therapist_posts,count($therapist_posts['data']) > 0 ? true:false,'TherapistPosts Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistPosts FOR Search ***********/
   public function filter(Request $request){
     $therapist_posts = $this->getter($request);
     $response = generateResponse($therapist_posts,count($therapist_posts['data']) > 0 ? true:false,'Filter TherapistPosts Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistPost ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['created_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadCroppedFile($request,'image','therapist_posts');
        $therapist_post = $therapist->therapist_posts()->create($data);
        $therapist_post->slug = Str::slug($therapist_post->name . ' ' . $therapist_post->id, '-');
        $therapist_post->save();
        $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post->id);
        $therapist_post = new PostsResource($therapist_post);
        DB::commit();
        $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post->id);
        $therapist_post = new PostsResource($therapist_post);
      $response = generateResponse($therapist_post,true ,'TherapistPosts Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Post $therapist_post)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_post->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post->id);
        if($therapist_post){
          $therapist_post = new PostsResource($therapist_post);
          $response = generateResponse($therapist_post,true,'TherapistPost Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistPost Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistPost ***********/
    public function update(CreateRequest $request, Post $therapist_post)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_post->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_posts',$therapist_post->image);
        } else {
            $data['image'] = $therapist_post->image;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_post->id, '-');
        $therapist_post->update($data);
        $therapist_post->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post->id);
        $therapist_post = new PostsResource($therapist_post);
        $response = generateResponse($therapist_post,true,'TherapistPost Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistPost Status***********/
    public function updateStatus(Request $request,Post $therapist_post){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_post->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_post->update([
          'is_active' => $therapist_post->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistPost Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistPost ***********/
    public function destroy(Request $request,Post $therapist_post)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_post->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_post->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_post->delete();
          }
          $response = generateResponse(null,true,'TherapistPost Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistPost ***********/
    public function destroyPermanently(Request $request,$therapist_post)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_post = $therapist->therapist_posts()->withTrashed()->find($therapist_post);
        if($therapist_post){
            if($therapist_post->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_post->trashed()) {
            $therapist_post->forceDelete();
            $response = generateResponse(null,true,'TherapistPost Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPost is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistPost not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistPost ***********/
    public function restore(Request $request,$therapist_post)
    {
      $therapist= auth()->user()->therapist;
      $therapist_post = $therapist->therapist_posts()->withTrashed()->find($therapist_post);
          if ($therapist_post->trashed()) {
            $therapist_post->restore();
            $response = generateResponse(null,true,'TherapistPost Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPost is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
